/*

  Macro_Scripts File
Purposes:  
    
	define action for each creatable Light object to hook up to the create main menu (or quads)
	defines macros for Quads

Revision History

	Nov 7th 2007, Pierre-Felix Breton
		Cleaning up to reflect new work from Photometric Lights
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	9 Juillet 2003: Pierre-Felix Breton
	performance improvements, optimizations

	26 Mai 2003: Pierre-felix Breton
	created for 3ds MAX 6
	
	April 22 2002: Fred Ruff
	created for 3ds MAX 5
*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK



--***********************************************************************************************
--Standard Lights

-------------------------------------------------------------------------------------------
macroScript Omni_Light 
            category:~OMNI_LIGHT_CATEGORY~
            internalCategory:"Lights and Cameras"
            tooltip:~OMNI_LIGHT_TOOLTIP~
			ButtonText:~OMNI_LIGHT_BUTTONTEXT~ 
            icon:#("Lights",3)
(
     on execute do StartObjectCreation OmniLight 
     on isChecked return mcrUtils.IsCreating OmniLight 
) 
-------------------------------------------------------------------------------------------
macroScript Target_Spotlight
            category:~TARGET_SPOTLIGHT_CATEGORY~
            internalCategory:"Lights and Cameras"
			ButtonText:~TARGET_SPOTLIGHT_BUTTONTEXT~
            tooltip:~TARGET_SPOTLIGHT_TOOLTIP~ 
            icon:#("Lights",1)
(
     on execute do StartObjectCreation Targetspot 
     on isChecked return mcrUtils.IsCreating Targetspot 
)
-------------------------------------------------------------------------------------------
macroScript Target_Directional_Light 
            category:~TARGET_DIRECTIONAL_LIGHT_CATEGORY~
            internalCategory:"Lights and Cameras"
            ButtonText:~TARGET_DIRECTIONAL_LIGHT_BUTTONTEXT~ 
            tooltip:~TARGET_DIRECTIONAL_LIGHT_TOOLTIP~ 
            icon:#("Lights",2)
(
     on execute do StartObjectCreation TargetDirectionalLight 
     on isChecked return mcrUtils.IsCreating TargetDirectionalLight 
)
-------------------------------------------------------------------------------------------
macroScript Free_Spotlight 
            category:~FREE_SPOTLIGHT_CATEGORY~
            internalCategory:"Lights and Cameras"
            ButtonText:~FREE_SPOTLIGHT_BUTTONTEXT~
            tooltip:~FREE_SPOTLIGHT_TOOLTIP~ 
            icon:#("Lights",4)
(
     on execute do StartObjectCreation FreeSpot 
     on isChecked return mcrUtils.IsCreating FreeSpot 
)
-------------------------------------------------------------------------------------------
macroScript Directional_Light
            category:~DIRECTIONAL_LIGHT_CATEGORY~
            internalCategory:"Lights and Cameras"
			ButtonText:~DIRECTIONAL_LIGHT_BUTTONTEXT~
            tooltip:~DIRECTIONAL_LIGHT_TOOLTIP~ 
            icon:#("Lights",5)
(
     on execute do StartObjectCreation DirectionalLight 
     on isChecked return mcrUtils.IsCreating DirectionalLight 
)
-------------------------------------------------------------------------------------------
macroScript Skylight
            category:~SKYLIGHT_CATEGORY~
            internalCategory:"Lights and Cameras"
			ButtonText:~SKYLIGHT_BUTTONTEXT~
            tooltip:~SKYLIGHT_TOOLTIP~ 
(
     on execute do StartObjectCreation Skylight
     on isChecked return mcrUtils.IsCreating Skylight
)


--***********************************************************************************************
--Mental Ray Scripted Lights
--dependency on the following files: \stdplugs\stdscripts\Light-mentalray_AreaOmni.ms and Light-mentalray_AreaSpot.ms

-------------------------------------------------------------------------------------------
macroScript AreaOmni
            category:~AREAOMNI_CATEGORY~
            internalCategory:"Lights and Cameras"
			ButtonText:~AREAOMNI_BUTTONTEXT~
            tooltip:~AREAOMNI_TOOLTIP~ 
(
     on execute do StartObjectCreation miAreaLightOmni
     on isChecked return mcrUtils.IsCreating miAreaLightOmni
)

-------------------------------------------------------------------------------------------
macroScript AreaSpot
            category:~AREASPOT_CATEGORY~
            internalCategory:"Lights and Cameras"
			ButtonText:~AREASPOT_BUTTONTEXT~
            tooltip:~AREASPOT_TOOLTIP~ 
(
     on execute do StartObjectCreation miAreaLight
     on isChecked return mcrUtils.IsCreating miAreaLight
)


--***********************************************************************************************
--Photometric Lights


--------------------------------------------------------------------------------------------------
macroScript Free_Point 
            category:~FREE_POINT_CATEGORY~
            internalCategory:"Lights and Cameras"
			ButtonText:~FREE_POINT_BUTTONTEXT~
            tooltip:~FREE_POINT_TOOLTIP~ 
            icon:#("PhotometricLights",3)
(
     on execute do StartObjectCreation Free_Point
     on isChecked return mcrUtils.IsCreating Free_Point
)


--------------------------------------------------------------------------------------------------
macroScript Target_Point 
            category:~TARGET_POINT_CATEGORY~
            internalCategory:"Lights and Cameras"
			ButtonText:~TARGET_POINT_BUTTONTEXT~
            tooltip:~TARGET_POINT_TOOLTIP~ 
            icon:#("PhotometricLights",2)
(
     on execute do StartObjectCreation Target_Point
     on isChecked return mcrUtils.IsCreating Target_Point
)


--------------------------------------------------------------------------------------------------




--------------------------------------------------------------------------------------------------
macroScript mr_Sky_Portal
            category:~MR_SKY_PORTAL_CATEGORY~
            internalCategory:"Lights and Cameras"
			ButtonText:~MR_SKY_PORTAL_BUTTONTEXT~
            tooltip:~MR_SKY_PORTAL_TOOLTIP~ 
(
     on execute do StartObjectCreation mr_Sky_Portal
     on isChecked return mcrUtils.IsCreating mr_Sky_Portal
     on IsVisible Return isKindOf mr_Sky_Portal  MAXWrapper 
)
--------------------------------------------------------------------------------------------------





--------------------------------------------------------------------------------------------------

--***********************************************************************************************
-- Light Commands

------------------------------------------------------------------------------------------
MacroScript Light_On
            ButtonText:~LIGHT_ON_BUTTONTEXT~
            category:~LIGHT_ON_CATEGORY~
            internalCategory:"Lights and Cameras"
            Tooltip:~LIGHT_ON_TOOLTIP~ 
(
	On IsVisible Return
		Try ( Filters.Is_Light $ and (Filters.HasBaseObjectProperty $ #on) )
		Catch ( false )
	on ischecked Return
		Try (if isProperty $ #on do $.on) 
		Catch ( false )
	
	On Execute Do
		Try (if isProperty $ #on do $.on = not $.on)
		Catch ()
	on altexecute type do (macros.run "Lights and Cameras" "Light_List") -- loc_notes: do not localize this
)



------------------------------------------------------------------------------------------
MacroScript Light_Shadows
            ButtonText:~LIGHT_SHADOWS_BUTTONTEXT~
            category:~LIGHT_SHADOWS_CATEGORY~
            internalCategory:"Lights and Cameras"
            Tooltip:~LIGHT_SHADOWS_TOOLTIP~ 
(

	On IsVisible Return
		Try ( ((Filters.Is_Light $) and (Filters.HasBaseObjectProperty $ #CastShadows)) ) 
		Catch ( false )
	On isEnabled Return
		Try ( not ((Filters.HasBaseObjectProperty $ #AmbientOnly) and ($.baseObject.AmbientOnly))) 
		Catch ( true )
	on ischecked Return
		Try ( $.baseObject.castShadows ) Catch ( false )
	On Execute Do 
		Try ($.baseObject.castShadows = (not $.baseObject.castShadows))	
		Catch()

)


------------------------------------------------------------------------------------------
MacroScript Light_AffectDiffuse
            ButtonText:~LIGHT_AFFECTDIFFUSE_BUTTONTEXT~
            category:~LIGHT_AFFECTDIFFUSE_CATEGORY~
            internalCategory:"Lights and Cameras"
            Tooltip:~LIGHT_AFFECTDIFFUSE_TOOLTIP~ 
(

	On IsVisible Return 
		Try ( ((Filters.Is_Light $) and (Filters.HasBaseObjectProperty $ #AffectDiffuse)and (Filters.HasBaseObjectProperty $ #AmbientOnly)) ) -- pfb, aug 30th 2001, added test for properties
		Catch( false )
	On isEnabled Return
		Try ( (not $.baseObject.AmbientOnly) ) -- pfb, aug 30th 2001, added context to be consistant with modify panel
		Catch( true )
	on ischecked Return
		Try ( $.AffectDiffuse ) Catch( false )
	
	On Execute Do
		Try ($.AffectDiffuse = (not $.AffectDiffuse))	
		Catch ()
)

------------------------------------------------------------------------------------------
MacroScript Light_AffectSpecular
            ButtonText:~LIGHT_AFFECTSPECULAR_BUTTONTEXT~
            category:~LIGHT_AFFECTSPECULAR_CATEGORY~
            internalCategory:"Lights and Cameras"
            Tooltip:~LIGHT_AFFECTSPECULAR_TOOLTIP~ 
(

	On IsVisible Return
		Try ( ((Filters.Is_Light $) and (Filters.HasBaseObjectProperty $ #AffectSpecular)and (Filters.HasBaseObjectProperty $ #AmbientOnly)) ) -- pfb, aug 30th 2001, added test for properties
		Catch ( false )
	On isEnabled Return 
		Try ( not $.baseObject.AmbientOnly ) -- pfb, aug 30th 2001, added context to be consistant with modify panel
		Catch ( true )
	on isChecked Return
		Try ( $.AffectSpecular ) Catch( false )
	
	On Execute Do 
		Try ($.AffectSpecular = (not $.AffectSpecular)) Catch()
		
)

------------------------------------------------------------------------------------------
MacroScript Light_AmbientOnly
            ButtonText:~LIGHT_AMBIENTONLY_BUTTONTEXT~
            category:~LIGHT_AMBIENTONLY_CATEGORY~
            internalCategory:"Lights and Cameras"
            Tooltip:~LIGHT_AMBIENTONLY_TOOLTIP~ 
(

	On IsVisible Return
		Try ( ((Filters.Is_Light $) and (Filters.HasBaseObjectProperty $ #AmbientOnly)) ) -- pfb, aug 30th 2001, added test for properties
		Catch ( false )

	on ischecked Do
		Try ( $.AmbientOnly ) Catch( false )
	
	On Execute Do
		Try ($.AmbientOnly = (not $.AmbientOnly)) Catch()
)

------------------------------------------------------------------------------------------
MacroScript Light_SelectTarget
            ButtonText:~LIGHT_SELECTTARGET_BUTTONTEXT~
            category:~LIGHT_SELECTTARGET_CATEGORY~
            internalCategory:"Lights and Cameras"
            Tooltip:~LIGHT_SELECTTARGET_TOOLTIP~ 
(

	On IsVisible Return
		Try ( ((Filters.Is_Light $) and(IsValidNode $.target)) ) -- pfb, aug 30th 2001, added test for properties so the 'select target' don't show on Omnis anymore
		Catch ( false )

	On Execute Do Try(select $.Target) Catch()

)

-----------------------------------------------------------------------------------------
macroScript Light_ActivateView
ButtonText:~LIGHT_ACTIVATEVIEW_BUTTONTEXT~
category:~LIGHT_ACTIVATEVIEW_CATEGORY~ 
internalCategory:"Lights and Cameras" 
Tooltip:~LIGHT_ACTIVATEVIEW_TOOLTIP~

(

	On IsVisible Return 
		Try ( ((Filters.Is_Light $) and (viewport.getcamera() != $) and (viewport.canSetToViewport $) ) )
		Catch ( false )

	On Execute Do
	( 
		Try(viewport.setcamera $) Catch()
	)
)

--***********************************************************************************************
-- Viewport Shadows


-----------------------------------------------------------------------------------------
MacroScript Light_Viewport_Shadows
            ButtonText:~LIGHT_VIEWPORT_SHADOWS_BUTTONTEXT~
            category:~LIGHT_VIEWPORT_SHADOWS_CATEGORY~
            internalCategory:"Lights and Cameras"
            Tooltip:~LIGHT_VIEWPORT_SHADOWS_TOOLTIP~ 
(

	On IsVisible Return
		Try ((Filters.Is_Light $)AND (IViewportShadingMgr.IsLightNodeSupported $)) -- pfb, aug 30th 2001, added test for properties
		Catch ( false )
	On isEnabled Return
		Try ( (not $.baseObject.AmbientOnly) and ( $.baseObject.castShadows) and ($.INodeShadingProperties.ViewportIllumination )) -- pfb, aug 30th 2001, added context to be consistant with modify panel
		Catch ( true )
	on ischecked Return
		Try ( $.INodeShadingProperties.ViewportShadowCasting) Catch ( false )
	On Execute Do 
		Try ($.INodeShadingProperties.ViewportShadowCasting = (not $.INodeShadingProperties.ViewportShadowCasting))	
		Catch()
)

MacroScript Light_Viewport_Illumination
            ButtonText:~LIGHT_VIEWPORT_ILLUMINATION_BUTTONTEXT~
            category:~LIGHT_VIEWPORT_ILLUMINATION_CATEGORY~
            internalCategory:"Lights and Cameras"
            Tooltip:~LIGHT_VIEWPORT_ILLUMINATION_TOOLTIP~ 
(

	On IsVisible Return
		Try ((Filters.Is_Light $)AND (IViewportShadingMgr.IsLightNodeSupported $)) -- pfb, aug 30th 2001, added test for properties
		Catch ( false )
	On isEnabled Return
		Try ( (not $.baseObject.AmbientOnly) and ($.on )) -- pfb, aug 30th 2001, added context to be consistant with modify panel
		Catch ( true )
	on ischecked Return
		Try ( $.INodeShadingProperties.Viewportillumination) Catch ( false )
	On Execute Do 
		Try ($.INodeShadingProperties.ViewportIllumination = (not $.INodeShadingProperties.ViewportIllumination))	
		Catch()
)

